@ lightup.asm

.syntax unified
.cpu cortex-m0plus
.thumb

.section .code, "ax"
    .align 4
    .global main
    .global isr
    .extern gpio7ctrl
    .extern siopoweron
    .extern resetreg
    .extern siooutput

.type main,%function
.thumb_func
main:
    .init:
        .equ siogp7, (1 << 7)
        .equ resetpads, (1 << 8)
        .equ resetspi, (1 << 16)
        .equ resetboth, (resetpads | resetspi)

        ldr r0,=stack
        ldr r0,[r0]
        mov sp,r0

        ldr r0,=resetreg
        ldr r0,[r0]
        ldr r1,=resetboth
        str r1, [r0]

        ldr r0,=gpio7ctrl
        ldr r0,[r0]
        movs r1,5
        str r1,[r0]


        ldr r1,=siogp7
        ldr r2,=siooutput
        ldr r2,[r2]

        ldr r0,=siopoweron
        ldr r0,[r0]        
        str r1,[r2]
        str r1,[r0]

    .loop:
        nop
        bal .loop

.type isr,%function
.thumb_func
isr:
        bx lr
