/* cpp.h */
#define _GNU_SOURCE
#include <stdio.h>
#include <stdbool.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <assert.h>
#include <errno.h>
#include <unistd.h>
#include <sys/stat.h>
#include "birchutils/birchutils.h"
#include "alloc/alloc.h"

typedef unsigned long long int int64;

enum e_type {
    String,
    Token
} packed;
typedef enum e_type type;

struct s_token {
    void *nothing;
} packed;
typedef struct s_token token;

struct s_line {
    type tag;
    union {
        int8 *strptr;
        token *tokptr;
    } packed;
    int32 lineno;
} packed;
typedef struct s_line line;

struct s_tuple {
    int8 *memspace;
    int32 bytes;
    int32 lines;
} packed;
typedef struct s_tuple tuple;

struct s_symboltable {
    int8 *identifier;
    union {
        int8 *strval;
        int32 intval;
    } packed;
} packed;
typedef struct s_symboltable symboltable;

#define $c (char *)
#define $i (int)
#define $1 (int8 *)
#define $2 (int16)
#define $4 (int32)
#define $8 (int64)

//#define alloc(x)    malloc(x)
//#define destroy(x)  free(x)
#define stringcopy(d,s,sz)  strncpy($c (d), $c (s), $i (sz))

// constructor
line *mkline(type,void*,int32);

line **parsefile(int8*,int32,int32);
line *allstages(line*,int32);
line *stage1(line*,int32);
line *stage2(line*,int32);
line *stage3(line*,int32);

int32 countchar(int8*,int8,int32);
int8 *findchar(int8*,int8,int32);
tuple *readfile(int8*);

bool whitespace(int8);
int main(int,char**);
