/* curses.h */
#define _GNU_SOURCE
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>
#include <assert.h>
#include <errno.h>
#include <birchutils.h>
#include <sys/ioctl.h>
#include <asm/termbits.h>

// temp functions
#define stringcopy(d,sz,s)  strncpy((d), (s), (sz))
#define copy(d,s,sz)        memcpy($c (d), $c (s), (sz))
#define stringlen(x)        strlen($c (x))

// macros
#define cprint(f,args...) do { \
    int8 _buf[256]; \
    \
    zero($1 &_buf, 256); \
    snprintf($c _buf, 255, $c (f), args); \
    cprint_(globalstate->current, _buf); \
} while(false)
#define update()               cupdate(globalstate->current)
#define cgetxy(w)              (win)
#define getxy()                 (globalstate->current)

#define packed __attribute((packed))
#define public __attribute((visibility("default")))
#define protected __attribute((visibility("hidden")))
#define _init __attribute((constructor))
#define _fini __attribute((destructor))
#define private static

typedef unsigned char int8;
typedef unsigned short int int16;
typedef unsigned int int32;
typedef unsigned long long int int64;
typedef unsigned short int frame;

#define $1 (int8 *)
#define $2 (int16)
#define $4 (int32)
#define $8 (int64)
#define $c (char *)
#define $i (int)

#define getbit(bm,bit)  ((bm[((bit)/8)] & (1<<((bit)%8))))
//    >> ((bit)%8))
#define setbit(bm,bit)  bm[((bit)/8)] = bm[((bit)/8)] | (1<<((bit)%8))
#define unsetbit(bm,bit)  bm[((bit)/8)] &= ~(1<<((bit)%8))

enum {
    Undefined,
    Char,
    Special
} packed;

enum e_skey {
    None,
    LeftArrow,
    UpArrow,
    RightArrow,
    DownArrow
} packed;
typedef enum e_skey skey;

struct s_framebuffer {
    frame *frames;
    int16 f1b;
    int8 bitmap[];
} packed;
typedef struct s_framebuffer framebuffer;

struct s_window {
    int8 id;
    int8 x;
    int8 y;
    int8 cols;
    int8 rows;
    int8 title[16];
    bool active;
    framebuffer *fb;
} packed;
typedef struct s_window window;

struct s_state {
    int8 nextid;
    window *root;
    window *current;
    struct termios term;
} packed;
typedef struct s_state state;

struct s_key {
    int8 tag:2;
    union {
        skey special;
        int8 ch;
    } packed;
} packed;
typedef struct s_key key;

// constructors
private framebuffer *mkfb(int16);
public window *mkwin(state*,int8,int8,int8*);
private state *mkstate(void);

public _init void initlibrary(void);
public _fini void exitlibrary(void);

private void sfblinear(window*,int8,int8,int8,int16);
private void sfbxy(window*,int8,int8,int8,int8,int8);
private void updatewin(window*,int8,int8,int8);
private key *getch(void);
private int8 readchar(void);
private void termenable(state*);
private void termdisable(state*);

public void cputchar(window*,int8,int8,int8);
public void cjump(window*,int8,int8);
public void cupdate(window*);
public void cframeset(window*,int8,int8,int8);
public void cprint_(window*,int8*);

protected void ansimove(int8,int8);
protected int8 *ansicolor(int8,int8);
protected int8 *ansireset(void);
protected void ansimode(void);

protected void showfb(framebuffer*,int16);
protected void showwin(window*);
protected void showstate(state*);

int main(int,char**);
 int main1(void);
 int main2(void);
