/* ddos umbrella phase 1 */
#include "umbrella.h"

Counters *statsinit(const char *interface) {
    int n;
    Counters *c;

    c = (Counters *)malloc(sizeof(struct s_counters));
    assert(c);
    memset(c, 0, sizeof(struct s_counters));

    c->sock = nl_socket_alloc();
    assert(c->sock);
    n = nl_connect(c->sock, NETLINK_ROUTE);
    if (n)
        assert_perror(errno);

    c->kbrx.type = CTkbrx;
    c->kbtx.type = CTkbtx;
    c->pktrx.type = CTpktrx;
    c->pkttx.type = CTpkttx;
    strncpy(c->interface, interface, 15);

    return c;
}

Bool statsupdate(Counters *c) {
    int n;
    unsigned long int pkttx, pktrx, kbtx, kbrx;

    rtnl_link_get_kernel(c->sock, 0, c->interface, &c->link);
    if (!n)
        return false;

#define x(y,z) y = rtnl_link_get_stat(c->link, RTNL_LINK_ ## z);
    Xcounters;
#undef x

    // if (!pktrx || !pkttx || !kbrx || !kbtx)
    if (!(_BitInt(256))kbrx || !(_BitInt(256))pktrx)
        return false;

#define x(y,_)    c->y.cnt = (y);
    Xcounters;
#undef x
    rtnl_link_put(c->link);

    return true;
}

char *grabip(struct sockaddr *s) {
    unsigned int ip, *ipp;
    unsigned char a, b, c, d;
    char *p, *p2;
    int x;

    p = malloc(8);
    assert(p);
    for (p2=p, x=0; x<8; p++, x++)
        *p = 0;
    p = p2;

    ipp = (unsigned int *)s;
    ipp++;
    ip = *ipp;

    a = (ip & 0xFF000000) >> 24;
    b = (ip & 0x00FF0000) >> 16;
    c = (ip & 0x0000FF00) >> 8;
    d = (ip & 0xFF);

    snprintf(p, 15, "%d.%d.%d.%d",
        d, c, b, a);

    return p;
}

int main(int argc, char *argv[]) {
    int n;
    char *ip, *_ip, *interface;
    struct ifaddrs *x, *xs;
    Counters *c;
    Bool b;

    if (argc < 2) {
        fprintf(stderr,
            "Usage: %s IP-ADDRESS\n", *argv);
        return -1;
    }
    ip = argv[1];

    n = getifaddrs(&xs);
    for (interface=0, x=xs; x; x = x->ifa_next) {
        _ip = grabip(x->ifa_addr);
        if (_ip)
            if (!strcmp(ip, _ip)) {
                interface = x->ifa_name;
                free(_ip);

                break;
            }
    }

    if (x)
        printf("%s\n", interface);
    else {
        fprintf(stderr, "Unable to find IP address.\n");
        return -1;
    }

    c = statsinit(interface);
    b = statsupdate(c);

    if (b)
        printf("%lu\n", c->pktrx.cnt);
    else
        return -1;

    return 0;
}








