/*
 * Get interface stats.
 *
 * EH plugins/network.rb retrieves the following for each interface:
 *  :name, :kbytes_in, :kbytes_out, :packets_in, :packets_out
 */

#include <stdio.h>
#include <unistd.h>
#include <inttypes.h>

#include <netlink/netlink.h>
#include <netlink/cache.h>
#include <netlink/route/link.h>

int main(void)
{
    struct rtnl_link *link;
    struct nl_sock *socket;
    uint64_t kbytes_in, kbytes_out, packets_in, packets_out;

    socket = nl_socket_alloc();
    nl_connect(socket, NETLINK_ROUTE);

    while (1) {
      if (rtnl_link_get_kernel(socket, 0, "ens192", &link) >= 0) {
        packets_in = rtnl_link_get_stat(link, RTNL_LINK_RX_PACKETS);
        packets_out = rtnl_link_get_stat(link, RTNL_LINK_TX_PACKETS);
        kbytes_in = rtnl_link_get_stat(link, RTNL_LINK_RX_BYTES);
        kbytes_out = rtnl_link_get_stat(link, RTNL_LINK_TX_BYTES);
        printf("packets_in=%" PRIu64 ",packets_out=%" PRIu64 ",kbytes_in=%" PRIu64 ",kbytes_out=%" PRIu64 "\n", packets_in, packets_out, kbytes_in, kbytes_out);
        rtnl_link_put(link);
        sleep(1);
      }
    }

    nl_socket_free(socket);
}

struct s_counter {
    CType type:3;
    time_t ts;
    unsigned long int cnt;
    unsigned int samples;
};












