/** umbrella.h */
#define _GNU_SOURCE
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <errno.h>
#include <sys/types.h>
#include <ifaddrs.h>
#include <inttypes.h>
#include <netlink/netlink.h>
#include <netlink/cache.h>
#include <netlink/route/link.h>

#define CTkbrx  1 // 00 01
#define CTkbtx  2 // 00 10
#define CTpktrx 4 // 01 00
#define CTpkttx 8 // 10 00
 #define true   1
#define false   0
 #define Current 0
#define Previous 1

#define Xcounters \
    x(kbrx,RX_BYTES) \
    x(kbtx,TX_BYTES) \
    x(pktrx,RX_PACKETS) \
    x(pkttx,TX_PACKETS)

#define statsfree(x)    nl_socket_free(x);

typedef unsigned char CType;
typedef unsigned char Bool;

struct s_counter {
    CType type:5;
    time_t ts;
    unsigned long int cnt;
    unsigned int per_sec5m;
    unsigned int samples;
};
typedef struct s_counter Counter;

#define x(y,_)    Counter y;
struct s_counters {
    Xcounters
    struct rtnl_link *link;
    struct nl_sock *sock;
    char interface[16];
};
typedef struct s_counters Counters;
#undef x

Counters *statsinit(const char*);
Bool statssample(Counters*);
