/* esther.h */
#define _GNU_SOURCE
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>
#include <assert.h>
#include <errno.h>
#include <birchutils.h>
#include <sys/socket.h>
#include <linux/if_packet.h>
#include <net/ethernet.h>
#include <sys/types.h>
#include <ifaddrs.h>
#include <net/if.h>

#define Timeout 2
#define packed __attribute__((packed))

typedef unsigned char int8;
typedef unsigned short int int16;
typedef unsigned int int32;
typedef unsigned long long int int64;
typedef int8 raw;

#define show(x) _Generic((x),   \
    ether*: showether($1 # x, (ether *)(x)), \
    ip*:    showip($1 # x, (ip *)(x)),  \
    icmp*:  showicmp($1 # x, (icmp *)(x)), \
    mac*:   showmac((mac *)(x)) \
)
#define eval(x) _Generic((x),   \
    ether*: evalether((ether *)(x)), \
    ip*:    evalip((ip *)(x)),  \
    icmp*:  evalicmp((icmp *)(x)), \
    default:evalraw($1 (x)) \
)
#define mkmac(x) _Generic((x),  \
    int64:  readmacint((int64)(x)), \
    int8*:  readmacstr($1 (x)) \
)
#define hex(x)  (((x) >= 'a') && ((x) <= 'f')) ? \
        ((x) - 0x57) : \
    ((x) - '0')
#define usage(x) do { \
        fprintf(stderr, \
            "Usage: %s <interface> <src mac> <dst mac> " \
            "<src ip> <dst ip> <msg>\n", \
            $c (x)); \
        return -1; \
} while(false)

#define parsemac(output) do { \
    x = *p++; \
    y = *p++; \
    x_ = hex(x); \
    y_ = hex(y); \
    byte = ((x_ << 4) | y_); \
    (output) = byte; \
    if (*p && parity) \
        if (*p++ != '.') \
            return (mac *)0; \
    parity ^= true; \
} while(false)

#define $1 (int8 *)
#define $2 (int16)
#define $4 (int32)
#define $8 (int64)
#define $c (char *)
#define $i (int)

enum e_type {
    unassigned = 0,
    echo,
    echoreply,
    L4icmp,
    L4tcp,
    L4udp,
    L4raw
} packed;
typedef enum e_type type;

enum e_ethertype {
    unset = 0,
    tIP = 0x0800,
    tARP = 0x0806
} packed;
typedef enum e_ethertype ethertype;

struct s_ip;
typedef struct s_ip ip;

struct s_mac {
    int64 addr:48;
} packed;
typedef struct s_mac mac;

struct s_ether {
    ethertype protocol;
    mac src;
    mac dst;
    ip *payload;
} packed;
typedef struct s_ether ether;

struct s_rawether {
    mac dst;
    mac src;
    int16 type;
} packed;

struct s_icmp {
    type kind:3;
    int16 size;
    int8 *data;
} packed;
typedef struct s_icmp icmp;

struct s_rawicmp {
    int8 type;
    int8 code;
    int16 checksum;
    int8 data[];
} packed;

union u_layer4 {
    icmp *icmppkt;
    raw *rawpkt;
};
typedef union u_layer4 layer4;

struct s_ip {
    type kind:3;
    int32 src;
    int32 dst;
    int16 id;
    layer4 payload;
} packed;

struct s_rawip {
    int8 ihl:4;
    int8 version:4;
    int8 dscp:6;
    int8 ecn:2;
    int16 length;
    int16 id;
    int8 flags:3;
    int16 offset:13;
    int8 ttl;
    int8 protocol;
    int16 checksum;
    int32 src;
    int32 dst;
    int8 options[];
} packed;

struct s_ping {
    int16 id;
    int16 seq;
    int8 data[];
} packed;


struct s_bytestring;
typedef struct s_bytestring bytestring;
typedef bytestring *(bsfunction)(bytestring*,bytestring*);

struct s_bytestring {
    int16 size;
    int8 *data;
    bsfunction *merge;
} packed;


int main(int,char**);
void copy(int8*,int8*,int16);
int16 checksum(int8*,int16);
int32 setup(int8*,mac*);
bool stringcompare(int8*,int8*);

int16 endian16(int16);
int16 stringlen(int8*);

// bytestring
bytestring *mkbytestring(int8*,int16);
static bytestring *bsmerge(bytestring*,bytestring*);

// raw
bytestring *evalraw(raw*);
int16 if2idx(int8*);

// ethernet
ether *mkether(ethertype,mac*,mac*);
int8 *showmac(mac*);
mac *readmacstr(int8*);
mac *readmacint(int64);
bytestring *evalether(ether*);
void showether(int8*,ether*);
bool sendframe(int32,ether*);

// icmp
icmp *mkicmp(type,const int8*,int16);
bytestring *evalicmp(icmp*);
void showicmp(int8*,icmp*);

// ip
ip *mkip(type,const int8*,const int8*,int16,int16*);
bytestring *evalip(ip*);
void showip(int8*,ip*);

 int main1(void);
 int main2(void);
 int main3(void);
 int main4(void);
 int main5(int,char**);
 int main6(void);
