/* xsc256.h */
#pragma once
#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>
#include <assert.h>
#include <errno.h>
#include <unistd.h>
#include <sys/types.h>
#include <sha2.h>
#include <sys/random.h>
#include <signal.h>
#include <fcntl.h>

typedef unsigned char int8;
typedef unsigned short int int16;
typedef unsigned int int32;
typedef unsigned long long int int64;
typedef unsigned _BitInt(128) int128;
typedef unsigned _BitInt(256) int256;

#define packed      __attribute__((packed))
#define export      __attribute__((visibility("default")))
#define protected   __attribute__((visibility("hidden")))
#define private     static
#define init    __attribute__((constructor))
#define alloc(x)    malloc((x))
#define destroy(x)  free((x))
#define xsc256decrypt(s,x,n) xsc256encrypt((s), (x), (n))

#define $1 (int8 *)
#define $2 (int16)
#define $4 (int32)
#define $8 (int64)
#define $16 (int128)
#define $32 (int256)
#define $i (int)
#define $c (char *)
#define $v (void *)
#define $s (semiword)

struct s_int192 {
    int256 x:192;
};
typedef struct s_int192 int192;

struct s_roundkey;
typedef struct s_roundkey roundkey;
struct s_roundkey {
    int8 id:4;
    int128 subkey;
    int64 rc;
    roundkey *next;
} packed;

struct s_semiword {
    int8 z:4;
    int8 y:4;
    int8 x:4;
} packed;
typedef struct s_semiword semiword;

struct s_state {
    int8 round;
    int8 w[16];
    semiword lastsbox[16];
    roundkey *subkey;
};
typedef struct s_state state;

struct s_tuple {
    semiword x;
    semiword y;
} packed;
typedef struct s_tuple tuple;

#define show(x)     _Generic((x), \
    int64:      showint64, \
    int128:     showint128, \
    int192:     showint192, \
    int256:     showint256, \
    semiword:   showsemiword, \
    state*:     showstate, \
    roundkey*: showroundkey \
)($1 # x, (x))
#define rotl1(b,x)  (((x) << 1) | \
    (((x) >> (b-1)) & 1))
#define rotr1(b,x) (((x) >> 1) | \
    (((x) & 1) << (b-1)))
#define rotl(x,p) (_Generic((x), \
    int8:   rotl8, \
    int16:  rotl16, \
    int32:  rotl32, \
    int64:  rotl64, \
    int128: rotl128 \
    ))((x),(p))
#define rotr(x,p) (_Generic((x), \
    int8:   rotr8, \
    int16:  rotr16, \
    int32:  rotr32, \
    int64:  rotr64, \
    int128: rotr128 \
    ))((x),(p))
#define rnds(s,x)   do { \
    int8 n; \
    \
    for (n=0; n<(x); n++) \
        rnd((s)); \
} while(false)
#define grabidx(x)  ((x) & 0x0f)
#define encryptfile(x) _Generic((x), \
    char*:          encryptfile_(xsc256kdf((char *)((unsigned char *)x))), \
    unsigned char*: encryptfile_(xsc256kdf((unsigned char *)(x))), \
    int256:         encryptfile_($32 (x)))
#define getbit8(x,n) ((x >> n) & 1)

export state *xsc256init(int256);
export unsigned char xsc256byte(state*);
export unsigned char *xsc256encrypt(state*,unsigned char*,unsigned short int);
export void xsc256uninit(state*);
export int256 xsc256kdf(unsigned char*);
export void encryptfile_(int256);

#ifdef Main
    private void showint64(int8*,int64);
    private void showint128(int8*,int128);
    private void showint192(int8*,int192);
    private void showint256(int8*,int256);
    private void showstate(int8*,state*);
    private void showroundkey(int8*,roundkey*);
    private void showsemiword(int8*,semiword);

    private state *mkstate(int256);
    private void zero(int8*,int16);
    private roundkey *mkroundkey(int8,int128,int64);
    private roundkey *gensubkeys(int128);
    private int192 xbox(int128);
    private int192 sboxes(state*,int192);
    private semiword sbox(semiword);
    private int128 cbox(int192);
    private int64 P(int16);
    private int128 f(state*,int128);
    private int128 g(int128,int64);
    private void rnd(state*);
    private roundkey *nextrk(state*);
    private bool getbit(int8*,int16);
    private void printbits(void*,int16,int8);
    
    private int32 genseed(void);
    private tuple *semirand(void);
    private semiword swap(semiword,semiword);
    private int8 runtrials(int8,bool);
    private int8 trial(int16,int8,int8);
    export int main(int,char**);
    private void mksbox(void);
    private bool savesbox(int8*,semiword***);
    export void handler(int);

    extern protected const int16 RCs[];
    extern protected const int8 Indices[];
    extern protected semiword (*Sbox)[0x10][0x10];
    // extern protected semiword Sbox[0x10][0x10][0x10];
    extern protected int8 sbox1d[];
#endif
