/* xsc256.c */
#define Main
#include <xsc256.h>

int192 xbox(int128 input) {
    int8 *x, *y;
    const int8 *iptr;
    int192 output;
    int8 n;

    x = $1 &input;
    y = $1 &output;
    iptr = Indices;

    for (n=0; n<16; n++) {
        if ((n%2))
            y[*iptr++] = x[n];
        else
            y[*iptr++] = y[*iptr++] = x[n];
    }

    return output;
}

void showint128(int8 *ident, int128 input) {
    void *mem;
    int32 *p;
    int8 i;

    printf("%s = 0x", ident);
    mem = $v ($v &input+16);
    for (i=0; i<4; i++) {
        mem -= 4;
        p = (int32 *)mem;
        printf("%.08x", $i *p);
    }
    printf("\n");

    return;
}

void showint192(int8 *ident, int192 input) {
    void *mem;
    int32 *p;
    int8 i;

    printf("%s = 0x", ident);
    mem = $v ($v &input+24);
    for (i=0; i<6; i++) {
        mem -= 4;
        p = (int32 *)mem;
        printf("%.08x", $i *p);
    }
    printf("\n");

    return;
}

int192 sboxes(int192 input) {
    int8 n;
    int192 output;
    semiword *x, *y;

    output.x = 0;
    x = (semiword *)&input;
    y = (semiword *)&output;

    for (n=0; n<16; n++)
            y[n] = sbox(x[n]);

    return output;
}

void showroundkey(int8 *id, roundkey *rk) {
    assert(rk);

    printf("%s = {\n", $c id);
    printf("  id=%d\n", rk->id);
    printf("  rc=%lld\n  ", $8 rk->rc);
    show(rk->subkey);
    printf("}\n");

    return;
}

semiword sbox(semiword input) {
    return Sbox[input.z][input.y][input.x];
}

int128 cbox(int192 input) {
    int128 output;
    int8 *x, *y;
    int8 n, idx;

    x = $1 &input;
    y = $1 &output;

    for (idx=n=0; n<8; n++) {
        y[idx] = x[idx] & x[++idx];
        y[idx] = x[idx] | x[++idx];
    }

    return output;
}

int128 f(int128 input) {
    int128 output;

    output = cbox(sboxes(xbox(input)));
    return output;
}

roundkey *mkroundkey(int8 id, int128 subkey, int64 rc) {
    int16 size;
    roundkey *p;

    size = sizeof(struct s_roundkey);
    p = alloc(size);
    assert(p);
    zero($1 p, size);

    p->id = id;
    p->subkey = subkey;
    p->rc = rc;
    p->next = (roundkey *)0;

    return p;
}

int128 mksubkey(int8 id, int128 subkey, int64 rc) {
    return subkey;
}

roundkey *gensubkeys(int128 key) {
    roundkey *p, *last, *first;
    int8 x;

    x = 0;
    first = mkroundkey(x, key, RCs[x]);
    x++;

    for (last = first; x<16; x++) {
        p = mkroundkey(x, last->subkey, RCs[x]);
        last->next = p;
        last = p;
    }
    last->next = first;

    return first;
}

void zero(int8* x, int16 size) {
    int16 n;
    int8 *p;

    for (p=x, n=size; n; n--, p++)
        *p = 0;
    
    return;
}

void mksbox() {
    int8 x,y,z;

    for (x=0; x<=0x0f; x++)
        for (y=0; y<=0x0f; y++)
            for (z=0; z<=0x0f; z++)
                Sbox[z][y][x] = (semiword){.x=z, .y=y, .z=x};
}

int main() {
    int8 n;
    int8 *p;
    int128 x;

    mksbox();
    x = 0;
    for (n=0, p=$1 &x; n<16; n++, p++)
        *p = n;

    for (n=0; n<64; n++)
        x = f(x);
    show(x);

    return 0;
}
