/* xsc256.h */
#pragma once
#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>
#include <assert.h>
#include <errno.h>
#include <unistd.h>
#include <sys/types.h>
#include <sha2.h>

typedef unsigned char int8;
typedef unsigned short int int16;
typedef unsigned int int32;
typedef unsigned long long int int64;
typedef unsigned _BitInt(128) int128;
typedef unsigned _BitInt(256) int256;

#define packed __attribute__((packed))
#define export __attribute__((visibility("default")))
#define alloc(x)    malloc((x))
#define destroy(x)  free((x))
#define xsc256decrypt(s,x,n) xsc256encrypt((s), (x), (n))

#define $1 (int8 *)
#define $2 (int16)
#define $4 (int32)
#define $8 (int64)
#define $16 (int128)
#define $32 (int256)
#define $i (int)
#define $c (char *)
#define $v (void *)

struct s_int192 {
    int256 x:192;
};
typedef struct s_int192 int192;

struct s_roundkey;
typedef struct s_roundkey roundkey;
struct s_roundkey {
    int8 id:4;
    int128 subkey;
    int64 rc;
    roundkey *next;
} packed;

struct s_state {
    int8 w[16];
    roundkey *subkey;
};
typedef struct s_state state;

struct s_semiword {
    int8 z:4;
    int8 y:4;
    int8 x:4;
} packed;
typedef struct s_semiword semiword;

#define show(x)     _Generic((x), \
    int64:      showint64, \
    int128:     showint128, \
    int192:     showint192, \
    int256:     showint256, \
    semiword:   showsemiword, \
    state*:     showstate, \
    roundkey*: showroundkey \
)($1 # x, (x))
#define rotl1(b,x)  (((x) << 1) | \
    (((x) >> (b-1)) & 1))
#define rotr1(b,x) (((x) >> 1) | \
    (((x) & 1) << (b-1)))
#define rotl(x,p) (_Generic((x), \
    int8:   rotl8, \
    int16:  rotl16, \
    int32:  rotl32, \
    int64:  rotl64, \
    int128: rotl128 \
    ))((x),(p))
#define rotr(x,p) (_Generic((x), \
    int8:   rotr8, \
    int16:  rotr16, \
    int32:  rotr32, \
    int64:  rotr64, \
    int128: rotr128 \
    ))((x),(p))
#define rnds(s,x)   do { \
    int8 n; \
    \
    for (n=0; n<(x); n++) \
        rnd((s)); \
} while(false)
#define grabidx(x)  ((x) & 0x0f)
#define encryptfile(x) _Generic((x), \
    char*:          encryptfile_(xsc256kdf((char *)((unsigned char *)x))), \
    unsigned char*: encryptfile_(xsc256kdf((unsigned char *)(x))), \
    int256:         encryptfile_($32 (x)))

void showint64(int8*,int64);
void showint128(int8*,int128);
void showint192(int8*,int192);
void showint256(int8*,int256);
void showstate(int8*,state*);
void showroundkey(int8*,roundkey*);
void showsemiword(int8*,semiword);

state *mkstate(int256);
int128 mksubkey(int8,int128,int64);

void zero(int8*,int16);
roundkey *mkroundkey(int8,int128,int64);
roundkey *gensubkeys(int128);
int192 xbox(int128);
int192 sboxes(int192);
semiword sbox(semiword);
int128 cbox(int192);
int64 P(int16);
int128 f(int128);
int128 g(int128,int64);
void rnd(state*);
roundkey *nextrk(state*);

export state *xsc256init(int256);
export unsigned char xsc256byte(state*);
export unsigned char *xsc256encrypt(state*,unsigned char*,unsigned short int);
export void xsc256uninit(state*);
export int256 xsc256kdf(unsigned char*);
export void encryptfile_(int256);

 void mksbox(void);
 void main1(void);
 void main2(void);
 void main3(void);
 void main4(unsigned char*);
 int main(int,char**);

#ifdef Main
    extern const int16 RCs[];
    extern const int8 Indices[];
    extern semiword Sbox[0x0f][0x0f][0x0f];
#endif
